require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartBiGAdventure = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartBiGAdventure.MsgBoxCBFuncs = {}

zmediaarguingcouple = Wherigo.ZMedia(cartBiGAdventure)
zmediaarguingcouple.Name="arguingcouple"
zmediaarguingcouple.Description=""
zmediaarguingcouple.AltText=""
zmediaarguingcouple.Id="a3a9ddbb-3399-46fd-aa98-a9f0aa288deb"
zmediaarguingcouple.Resources = {
{ Type = "jpg", Filename = "couple.jpg", Directives = {},},
}
zmediaarguingcouple_f = Wherigo.ZMedia(cartBiGAdventure)
zmediaarguingcouple_f.Name="arguingcouple_f"
zmediaarguingcouple_f.Description=""
zmediaarguingcouple_f.AltText=""
zmediaarguingcouple_f.Id="b354195b-a097-4fbf-80a4-875145929468"
zmediaarguingcouple_f.Resources = {
{ Type = "jpg", Filename = "couple_f.jpg", Directives = {},},
}
zmediaarguingcouple_m = Wherigo.ZMedia(cartBiGAdventure)
zmediaarguingcouple_m.Name="arguingcouple_m"
zmediaarguingcouple_m.Description=""
zmediaarguingcouple_m.AltText=""
zmediaarguingcouple_m.Id="cdb6e743-b38e-4b1e-b9b0-91f059f10b74"
zmediaarguingcouple_m.Resources = {
{ Type = "jpg", Filename = "couple_m.jpg", Directives = {},},
}
zmediadogwalker = Wherigo.ZMedia(cartBiGAdventure)
zmediadogwalker.Name="dogwalker"
zmediadogwalker.Description=""
zmediadogwalker.AltText=""
zmediadogwalker.Id="fce77c53-2b77-4d21-af14-4c1abca9eed0"
zmediadogwalker.Resources = {
{ Type = "jpg", Filename = "dogwalker.jpg", Directives = {},},
}
zmediaengrossedreader = Wherigo.ZMedia(cartBiGAdventure)
zmediaengrossedreader.Name="engrossedreader"
zmediaengrossedreader.Description=""
zmediaengrossedreader.AltText=""
zmediaengrossedreader.Id="dadecca4-dbab-4fa9-844b-bd3c3d35a352"
zmediaengrossedreader.Resources = {
{ Type = "jpg", Filename = "engrossedreader.jpg", Directives = {},},
}
zmediafence = Wherigo.ZMedia(cartBiGAdventure)
zmediafence.Name="fence"
zmediafence.Description=""
zmediafence.AltText=""
zmediafence.Id="a07b3783-03ff-4612-a724-bcf85133e52b"
zmediafence.Resources = {
{ Type = "jpg", Filename = "fence.jpg", Directives = {},},
}
zmediagazebo = Wherigo.ZMedia(cartBiGAdventure)
zmediagazebo.Name="gazebo"
zmediagazebo.Description=""
zmediagazebo.AltText=""
zmediagazebo.Id="d46242c0-7773-44f2-bb35-be80edbd525b"
zmediagazebo.Resources = {
{ Type = "jpg", Filename = "gazebo.jpg", Directives = {},},
}
zmediamusic = Wherigo.ZMedia(cartBiGAdventure)
zmediamusic.Name="music"
zmediamusic.Description=""
zmediamusic.AltText=""
zmediamusic.Id="25d619c4-a988-48c2-acfa-3d9d4e4b5794"
zmediamusic.Resources = {
{ Type = "jpg", Filename = "music.jpg", Directives = {},},
}
zmediapillar = Wherigo.ZMedia(cartBiGAdventure)
zmediapillar.Name="pillar"
zmediapillar.Description=""
zmediapillar.AltText=""
zmediapillar.Id="abfba8d0-86eb-4c35-b495-8c12005490ce"
zmediapillar.Resources = {
{ Type = "jpg", Filename = "pillar.jpg", Directives = {},},
}
zmediasadie = Wherigo.ZMedia(cartBiGAdventure)
zmediasadie.Name="sadie"
zmediasadie.Description=""
zmediasadie.AltText=""
zmediasadie.Id="c2934c6c-f7ef-4052-9a37-b1f176b3a495"
zmediasadie.Resources = {
{ Type = "jpg", Filename = "sadie.jpg", Directives = {},},
}
zmediasoar = Wherigo.ZMedia(cartBiGAdventure)
zmediasoar.Name="soar"
zmediasoar.Description=""
zmediasoar.AltText=""
zmediasoar.Id="f04f80cf-49c2-449e-b15a-147abfe141ef"
zmediasoar.Resources = {
{ Type = "jpg", Filename = "soar.jpg", Directives = {},},
}
zmediastudent = Wherigo.ZMedia(cartBiGAdventure)
zmediastudent.Name="student"
zmediastudent.Description=""
zmediastudent.AltText=""
zmediastudent.Id="b6343369-01a3-4908-aa34-aad4f733d4f9"
zmediastudent.Resources = {
{ Type = "jpg", Filename = "student.jpg", Directives = {},},
}
zmediasundial = Wherigo.ZMedia(cartBiGAdventure)
zmediasundial.Name="sundial"
zmediasundial.Description=""
zmediasundial.AltText=""
zmediasundial.Id="aa029b1f-74ff-4518-92b4-173807c7fed7"
zmediasundial.Resources = {
{ Type = "jpg", Filename = "sundial.jpg", Directives = {},},
}
zmediaviolinist = Wherigo.ZMedia(cartBiGAdventure)
zmediaviolinist.Name="violinist"
zmediaviolinist.Description=""
zmediaviolinist.AltText=""
zmediaviolinist.Id="3f7f7956-73f5-43a7-8a6e-fe0c941aa67e"
zmediaviolinist.Resources = {
{ Type = "jpg", Filename = "violinist.jpg", Directives = {},},
}
zmediawings = Wherigo.ZMedia(cartBiGAdventure)
zmediawings.Name="wings"
zmediawings.Description=""
zmediawings.AltText=""
zmediawings.Id="894556fd-67ea-4c31-99a8-d5a08b3d12ab"
zmediawings.Resources = {
{ Type = "jpg", Filename = "wings.jpg", Directives = {},},
}
zmediayoungcouple = Wherigo.ZMedia(cartBiGAdventure)
zmediayoungcouple.Name="youngcouple"
zmediayoungcouple.Description=""
zmediayoungcouple.AltText=""
zmediayoungcouple.Id="7f05df6f-94dc-4661-ba7c-85016179fa1f"
zmediayoungcouple.Resources = {
{ Type = "jpg", Filename = "youngcouple.jpg", Directives = {},},
}
zmediakeepoffgrass = Wherigo.ZMedia(cartBiGAdventure)
zmediakeepoffgrass.Name="keepoffgrass"
zmediakeepoffgrass.Description=""
zmediakeepoffgrass.AltText=""
zmediakeepoffgrass.Id="05465618-8dc3-42fa-95bf-4e9bf103eb4f"
zmediakeepoffgrass.Resources = {
{ Type = "jpg", Filename = "keepoffgrass.jpg", Directives = {},},
}
zmediaboyonbench = Wherigo.ZMedia(cartBiGAdventure)
zmediaboyonbench.Name="boyonbench"
zmediaboyonbench.Description=""
zmediaboyonbench.AltText=""
zmediaboyonbench.Id="53fe6086-1c56-4410-b55c-57351863c7b9"
zmediaboyonbench.Resources = {
{ Type = "jpg", Filename = "boyonbench.jpg", Directives = {},},
}
zmediabanner = Wherigo.ZMedia(cartBiGAdventure)
zmediabanner.Name="banner"
zmediabanner.Description=""
zmediabanner.AltText=""
zmediabanner.Id="a9b57045-68b5-46b6-9938-48c0cc50cc4b"
zmediabanner.Resources = {
{ Type = "jpg", Filename = "banner.jpg", Directives = {},},
}
zmediaicon = Wherigo.ZMedia(cartBiGAdventure)
zmediaicon.Name="icon"
zmediaicon.Description=""
zmediaicon.AltText=""
zmediaicon.Id="85942dd1-c4c9-4ad5-93ee-86987ea307f5"
zmediaicon.Resources = {
{ Type = "jpg", Filename = "icon.jpg", Directives = {},},
}
zmediaipod = Wherigo.ZMedia(cartBiGAdventure)
zmediaipod.Name="ipod"
zmediaipod.Description=""
zmediaipod.AltText=""
zmediaipod.Id="809b1915-1f17-4bd6-8fbc-47e57b73251d"
zmediaipod.Resources = {
{ Type = "jpg", Filename = "ipod.jpg", Directives = {},},
}
-- Cartridge Info --
cartBiGAdventure.Id="732b5858-324d-4f82-a48e-4fac62e7d007"
cartBiGAdventure.Name="BiG Adventure"
cartBiGAdventure.Description=[[Sadie's BiG Adventure

A day in the Bicentennial Gardens turns into a small adventure when you find someone in need.]]
cartBiGAdventure.Visible=true
cartBiGAdventure.Activity="Geocache"
cartBiGAdventure.StartingLocationDescription=[[]]
cartBiGAdventure.StartingLocation = ZonePoint(36.09276,-79.84143,0)
cartBiGAdventure.Version="2.00"
cartBiGAdventure.Company="Ranger Fox Adventures, Ltd."
cartBiGAdventure.Author="Ranger Fox"
cartBiGAdventure.BuilderVersion="2.0.5129.5086"
cartBiGAdventure.CreateDate="2/11/2009 8:19:52 PM"
cartBiGAdventure.PublishDate="1/1/0001 12:00:00 AM"
cartBiGAdventure.UpdateDate="2/14/2009 7:31:22 PM"
cartBiGAdventure.LastPlayedDate="1/1/0001 12:00:00 AM"
cartBiGAdventure.TargetDevice="PocketPC"
cartBiGAdventure.TargetDeviceVersion="0"
cartBiGAdventure.StateId="1"
cartBiGAdventure.CountryId="2"
cartBiGAdventure.Complete=false
cartBiGAdventure.UseLogging=true
cartBiGAdventure.Media=zmediabanner
cartBiGAdventure.Icon=zmediaicon

-- Zones --
zoneGirl = Wherigo.Zone(cartBiGAdventure)
zoneGirl.Id="8d2374bf-1e6e-4cb9-9d0b-df07359a24d2"
zoneGirl.Name="Girl"
zoneGirl.Description=[[This young girl seems to be worried about something and walking around feverishly.  What is she doing?]]
zoneGirl.Visible=true
zoneGirl.DistanceRange = Distance(100, "feet")
zoneGirl.ShowObjects="OnProximity"
zoneGirl.ProximityRange = Distance(10, "feet")
zoneGirl.AllowSetPositionTo=false
zoneGirl.Active=true
zoneGirl.Points = {
  ZonePoint(36.09257,-79.84359,0),
  ZonePoint(36.09257,-79.84347,0),
  ZonePoint(36.09247,-79.84347,0),
  ZonePoint(36.09247,-79.84359,0)
}
zoneGirl.OriginalPoint = ZonePoint(36.09252,-79.84353,0)
zoneGirl.DistanceRangeUOM = "Feet"
zoneGirl.ProximityRangeUOM = "Feet"
zoneGirl.OutOfRangeName = ""
zoneGirl.InRangeName = ""
zoneGirl.Media=zmediasadie

zoneSadie = Wherigo.Zone(cartBiGAdventure)
zoneSadie.Id="17e32bd2-15b5-4f7b-a446-1bf9156539fe"
zoneSadie.Name="Sadie"
zoneSadie.Description=[[Sadie found something.  Follow her to see]]
zoneSadie.Visible=true
zoneSadie.DistanceRange = Distance(-1, "feet")
zoneSadie.ShowObjects="OnProximity"
zoneSadie.ProximityRange = Distance(20, "feet")
zoneSadie.AllowSetPositionTo=false
zoneSadie.Active=false
zoneSadie.Points = {
  ZonePoint(36.0925,-79.8418,0),
  ZonePoint(36.0925,-79.84168,0),
  ZonePoint(36.0924,-79.84168,0),
  ZonePoint(36.0924,-79.8418,0)
}
zoneSadie.OriginalPoint = ZonePoint(36.09245,-79.84174,0)
zoneSadie.DistanceRangeUOM = "Feet"
zoneSadie.ProximityRangeUOM = "Feet"
zoneSadie.OutOfRangeName = ""
zoneSadie.InRangeName = ""
zoneSadie.Media=zmediasadie

zoneArguingCouple = Wherigo.Zone(cartBiGAdventure)
zoneArguingCouple.Id="aa0b92e0-47f8-4c36-b6ed-ced2bf4cfbd7"
zoneArguingCouple.Name="Arguing Couple"
zoneArguingCouple.Description=[[There is a couple here who seem to be arguing.]]
zoneArguingCouple.Visible=true
zoneArguingCouple.DistanceRange = Distance(150, "feet")
zoneArguingCouple.ShowObjects="OnProximity"
zoneArguingCouple.ProximityRange = Distance(15, "feet")
zoneArguingCouple.AllowSetPositionTo=false
zoneArguingCouple.Active=true
zoneArguingCouple.Points = {
  ZonePoint(36.0925,-79.84243,0),
  ZonePoint(36.0925,-79.84231,0),
  ZonePoint(36.0924,-79.84231,0),
  ZonePoint(36.0924,-79.84243,0)
}
zoneArguingCouple.OriginalPoint = ZonePoint(36.09245,-79.84237,0)
zoneArguingCouple.DistanceRangeUOM = "Feet"
zoneArguingCouple.ProximityRangeUOM = "Feet"
zoneArguingCouple.OutOfRangeName = ""
zoneArguingCouple.InRangeName = ""
zoneArguingCouple.Media=zmediaarguingcouple

zoneWeddingGazebo = Wherigo.Zone(cartBiGAdventure)
zoneWeddingGazebo.Id="17e32bd2-15b5-4f7b-a446-1bf9156539e0"
zoneWeddingGazebo.Name="Wedding Gazebo"
zoneWeddingGazebo.Description=[[A gazebo used for some weddings.]]
zoneWeddingGazebo.Visible=true
zoneWeddingGazebo.DistanceRange = Distance(150, "feet")
zoneWeddingGazebo.ShowObjects="OnProximity"
zoneWeddingGazebo.ProximityRange = Distance(15, "feet")
zoneWeddingGazebo.AllowSetPositionTo=false
zoneWeddingGazebo.Active=true
zoneWeddingGazebo.Points = {
  ZonePoint(36.0925,-79.8418,0),
  ZonePoint(36.0925,-79.84168,0),
  ZonePoint(36.0924,-79.84168,0),
  ZonePoint(36.0924,-79.8418,0)
}
zoneWeddingGazebo.OriginalPoint = ZonePoint(36.09245,-79.84174,0)
zoneWeddingGazebo.DistanceRangeUOM = "Feet"
zoneWeddingGazebo.ProximityRangeUOM = "Feet"
zoneWeddingGazebo.OutOfRangeName = ""
zoneWeddingGazebo.InRangeName = ""
zoneWeddingGazebo.Media=zmediagazebo

zoneSundial = Wherigo.Zone(cartBiGAdventure)
zoneSundial.Id="7a8349c2-d999-455b-b74d-9fc9ce12b312"
zoneSundial.Name="Sundial"
zoneSundial.Description=[[An odd-shaped sundial sculpture.]]
zoneSundial.Visible=true
zoneSundial.DistanceRange = Distance(150, "feet")
zoneSundial.ShowObjects="OnProximity"
zoneSundial.ProximityRange = Distance(15, "feet")
zoneSundial.AllowSetPositionTo=false
zoneSundial.Active=true
zoneSundial.Points = {
  ZonePoint(36.09238,-79.84158,0),
  ZonePoint(36.09238,-79.84146,0),
  ZonePoint(36.09228,-79.84146,0),
  ZonePoint(36.09228,-79.84158,0)
}
zoneSundial.OriginalPoint = ZonePoint(36.09233,-79.84152,0)
zoneSundial.DistanceRangeUOM = "Feet"
zoneSundial.ProximityRangeUOM = "Feet"
zoneSundial.OutOfRangeName = ""
zoneSundial.InRangeName = ""
zoneSundial.Media=zmediasundial

zoneStatueOntheFence = Wherigo.Zone(cartBiGAdventure)
zoneStatueOntheFence.Id="9169a3f6-0da3-4633-a79a-5cb1051e7035"
zoneStatueOntheFence.Name="Statue: On the Fence"
zoneStatueOntheFence.Description=[[A statue depicting two young people sitting on a fence.]]
zoneStatueOntheFence.Visible=true
zoneStatueOntheFence.DistanceRange = Distance(150, "feet")
zoneStatueOntheFence.ShowObjects="OnProximity"
zoneStatueOntheFence.ProximityRange = Distance(15, "feet")
zoneStatueOntheFence.AllowSetPositionTo=false
zoneStatueOntheFence.Active=true
zoneStatueOntheFence.Points = {
  ZonePoint(36.09232,-79.84142,0),
  ZonePoint(36.09232,-79.8413,0),
  ZonePoint(36.09222,-79.8413,0),
  ZonePoint(36.09222,-79.84142,0)
}
zoneStatueOntheFence.OriginalPoint = ZonePoint(36.09227,-79.84136,0)
zoneStatueOntheFence.DistanceRangeUOM = "Feet"
zoneStatueOntheFence.ProximityRangeUOM = "Feet"
zoneStatueOntheFence.OutOfRangeName = ""
zoneStatueOntheFence.InRangeName = ""
zoneStatueOntheFence.Media=zmediafence

zoneStatueSoar = Wherigo.Zone(cartBiGAdventure)
zoneStatueSoar.Id="bc7922cd-8829-4f19-b04a-129a4e7bbae1"
zoneStatueSoar.Name="Statue: Soar"
zoneStatueSoar.Description=[[]]
zoneStatueSoar.Visible=true
zoneStatueSoar.DistanceRange = Distance(150, "feet")
zoneStatueSoar.ShowObjects="OnProximity"
zoneStatueSoar.ProximityRange = Distance(15, "feet")
zoneStatueSoar.AllowSetPositionTo=false
zoneStatueSoar.Active=true
zoneStatueSoar.Points = {
  ZonePoint(36.0923,-79.84271,0),
  ZonePoint(36.0923,-79.84259,0),
  ZonePoint(36.0922,-79.84259,0),
  ZonePoint(36.0922,-79.84271,0)
}
zoneStatueSoar.OriginalPoint = ZonePoint(36.09225,-79.84265,0)
zoneStatueSoar.DistanceRangeUOM = "Feet"
zoneStatueSoar.ProximityRangeUOM = "Feet"
zoneStatueSoar.OutOfRangeName = ""
zoneStatueSoar.InRangeName = ""
zoneStatueSoar.Media=zmediasoar

zoneCamberlysGarden = Wherigo.Zone(cartBiGAdventure)
zoneCamberlysGarden.Id="c4b4e68b-b661-4cbc-affe-cc6a8d1d8c24"
zoneCamberlysGarden.Name="Camberly's Garden"
zoneCamberlysGarden.Description=[[A nice area with a music stand.]]
zoneCamberlysGarden.Visible=true
zoneCamberlysGarden.DistanceRange = Distance(150, "feet")
zoneCamberlysGarden.ShowObjects="OnProximity"
zoneCamberlysGarden.ProximityRange = Distance(15, "feet")
zoneCamberlysGarden.AllowSetPositionTo=false
zoneCamberlysGarden.Active=true
zoneCamberlysGarden.Points = {
  ZonePoint(36.09196,-79.84339,0),
  ZonePoint(36.09196,-79.84317,0),
  ZonePoint(36.09178,-79.84317,0),
  ZonePoint(36.09178,-79.84339,0)
}
zoneCamberlysGarden.OriginalPoint = ZonePoint(36.09187,-79.84328,0)
zoneCamberlysGarden.DistanceRangeUOM = "Feet"
zoneCamberlysGarden.ProximityRangeUOM = "Feet"
zoneCamberlysGarden.OutOfRangeName = ""
zoneCamberlysGarden.InRangeName = ""
zoneCamberlysGarden.Media=zmediamusic

zoneStatueTheStudent = Wherigo.Zone(cartBiGAdventure)
zoneStatueTheStudent.Id="5196bfb0-9ac4-458c-9eca-43bc9bec744e"
zoneStatueTheStudent.Name="Statue: The Student"
zoneStatueTheStudent.Description=[[]]
zoneStatueTheStudent.Visible=true
zoneStatueTheStudent.DistanceRange = Distance(150, "feet")
zoneStatueTheStudent.ShowObjects="OnProximity"
zoneStatueTheStudent.ProximityRange = Distance(15, "feet")
zoneStatueTheStudent.AllowSetPositionTo=false
zoneStatueTheStudent.Active=true
zoneStatueTheStudent.Points = {
  ZonePoint(36.09259,-79.84316,0),
  ZonePoint(36.09259,-79.84304,0),
  ZonePoint(36.09249,-79.84304,0),
  ZonePoint(36.09249,-79.84316,0)
}
zoneStatueTheStudent.OriginalPoint = ZonePoint(36.09254,-79.8431,0)
zoneStatueTheStudent.DistanceRangeUOM = "Feet"
zoneStatueTheStudent.ProximityRangeUOM = "Feet"
zoneStatueTheStudent.OutOfRangeName = ""
zoneStatueTheStudent.InRangeName = ""
zoneStatueTheStudent.Media=zmediastudent

zoneDonationPillar = Wherigo.Zone(cartBiGAdventure)
zoneDonationPillar.Id="1e6413b9-9e6b-429f-80ee-879ff81b3e78"
zoneDonationPillar.Name="Donation Pillar"
zoneDonationPillar.Description=[[]]
zoneDonationPillar.Visible=true
zoneDonationPillar.DistanceRange = Distance(150, "feet")
zoneDonationPillar.ShowObjects="OnProximity"
zoneDonationPillar.ProximityRange = Distance(15, "feet")
zoneDonationPillar.AllowSetPositionTo=false
zoneDonationPillar.Active=true
zoneDonationPillar.Points = {
  ZonePoint(36.09309,-79.84302,0),
  ZonePoint(36.09309,-79.8429,0),
  ZonePoint(36.09299,-79.8429,0),
  ZonePoint(36.09299,-79.84302,0)
}
zoneDonationPillar.OriginalPoint = ZonePoint(36.09304,-79.84296,0)
zoneDonationPillar.DistanceRangeUOM = "Feet"
zoneDonationPillar.ProximityRangeUOM = "Feet"
zoneDonationPillar.OutOfRangeName = ""
zoneDonationPillar.InRangeName = ""
zoneDonationPillar.Media=zmediapillar

zonePicnicArea = Wherigo.Zone(cartBiGAdventure)
zonePicnicArea.Id="419dd446-cc60-4666-be56-63a429b72e58"
zonePicnicArea.Name="Picnic Area"
zonePicnicArea.Description=[[]]
zonePicnicArea.Visible=true
zonePicnicArea.DistanceRange = Distance(150, "feet")
zonePicnicArea.ShowObjects="OnProximity"
zonePicnicArea.ProximityRange = Distance(15, "feet")
zonePicnicArea.AllowSetPositionTo=false
zonePicnicArea.Active=true
zonePicnicArea.Points = {
  ZonePoint(36.09338,-79.84162,0),
  ZonePoint(36.09338,-79.8415,0),
  ZonePoint(36.09328,-79.8415,0),
  ZonePoint(36.09328,-79.84162,0)
}
zonePicnicArea.OriginalPoint = ZonePoint(36.09333,-79.84156,0)
zonePicnicArea.DistanceRangeUOM = "Feet"
zonePicnicArea.ProximityRangeUOM = "Feet"
zonePicnicArea.OutOfRangeName = ""
zonePicnicArea.InRangeName = ""

zoneEngrossedReader = Wherigo.Zone(cartBiGAdventure)
zoneEngrossedReader.Id="9b27ed09-aa15-40ea-878a-cf0ddc910b02"
zoneEngrossedReader.Name="Engrossed Reader"
zoneEngrossedReader.Description=[[]]
zoneEngrossedReader.Visible=true
zoneEngrossedReader.DistanceRange = Distance(150, "feet")
zoneEngrossedReader.ShowObjects="OnProximity"
zoneEngrossedReader.ProximityRange = Distance(15, "feet")
zoneEngrossedReader.AllowSetPositionTo=false
zoneEngrossedReader.Active=true
zoneEngrossedReader.Points = {
  ZonePoint(36.09424,-79.84335,0),
  ZonePoint(36.09424,-79.84323,0),
  ZonePoint(36.09414,-79.84323,0),
  ZonePoint(36.09414,-79.84335,0)
}
zoneEngrossedReader.OriginalPoint = ZonePoint(36.09419,-79.84329,0)
zoneEngrossedReader.DistanceRangeUOM = "Feet"
zoneEngrossedReader.ProximityRangeUOM = "Feet"
zoneEngrossedReader.OutOfRangeName = ""
zoneEngrossedReader.InRangeName = ""
zoneEngrossedReader.Media=zmediaengrossedreader

zoneDogWalker = Wherigo.Zone(cartBiGAdventure)
zoneDogWalker.Id="ab5c8e3e-c9c7-41e7-8f63-946d697f182d"
zoneDogWalker.Name="Dog Walker"
zoneDogWalker.Description=[[]]
zoneDogWalker.Visible=true
zoneDogWalker.DistanceRange = Distance(150, "feet")
zoneDogWalker.ShowObjects="OnProximity"
zoneDogWalker.ProximityRange = Distance(15, "feet")
zoneDogWalker.AllowSetPositionTo=false
zoneDogWalker.Active=true
zoneDogWalker.Points = {
  ZonePoint(36.09412,-79.8426,0),
  ZonePoint(36.09412,-79.84248,0),
  ZonePoint(36.09402,-79.84248,0),
  ZonePoint(36.09402,-79.8426,0)
}
zoneDogWalker.OriginalPoint = ZonePoint(36.09407,-79.84254,0)
zoneDogWalker.DistanceRangeUOM = "Feet"
zoneDogWalker.ProximityRangeUOM = "Feet"
zoneDogWalker.OutOfRangeName = ""
zoneDogWalker.InRangeName = ""
zoneDogWalker.Media=zmediadogwalker

zoneBoyonaBench = Wherigo.Zone(cartBiGAdventure)
zoneBoyonaBench.Id="7670e7d8-696c-4fe2-8ff7-deff20b0c2ff"
zoneBoyonaBench.Name="Boy on a Bench"
zoneBoyonaBench.Description=[[]]
zoneBoyonaBench.Visible=true
zoneBoyonaBench.DistanceRange = Distance(150, "feet")
zoneBoyonaBench.ShowObjects="OnProximity"
zoneBoyonaBench.ProximityRange = Distance(15, "feet")
zoneBoyonaBench.AllowSetPositionTo=false
zoneBoyonaBench.Active=true
zoneBoyonaBench.Points = {
  ZonePoint(36.09385,-79.84106,0),
  ZonePoint(36.09385,-79.84094,0),
  ZonePoint(36.09375,-79.84094,0),
  ZonePoint(36.09375,-79.84106,0)
}
zoneBoyonaBench.OriginalPoint = ZonePoint(36.0938,-79.841,0)
zoneBoyonaBench.DistanceRangeUOM = "Feet"
zoneBoyonaBench.ProximityRangeUOM = "Feet"
zoneBoyonaBench.OutOfRangeName = ""
zoneBoyonaBench.InRangeName = ""
zoneBoyonaBench.Media=zmediaboyonbench

zoneDaylilyGarden = Wherigo.Zone(cartBiGAdventure)
zoneDaylilyGarden.Id="3e64f444-a825-4820-bc8b-1c53b3db45da"
zoneDaylilyGarden.Name="Daylily Garden"
zoneDaylilyGarden.Description=[[]]
zoneDaylilyGarden.Visible=true
zoneDaylilyGarden.DistanceRange = Distance(150, "feet")
zoneDaylilyGarden.ShowObjects="OnProximity"
zoneDaylilyGarden.ProximityRange = Distance(15, "feet")
zoneDaylilyGarden.AllowSetPositionTo=false
zoneDaylilyGarden.Active=true
zoneDaylilyGarden.Points = {
  ZonePoint(36.09282,-79.8435,0),
  ZonePoint(36.09282,-79.84338,0),
  ZonePoint(36.09272,-79.84338,0),
  ZonePoint(36.09272,-79.8435,0)
}
zoneDaylilyGarden.OriginalPoint = ZonePoint(36.09277,-79.84344,0)
zoneDaylilyGarden.DistanceRangeUOM = "Feet"
zoneDaylilyGarden.ProximityRangeUOM = "Feet"
zoneDaylilyGarden.OutOfRangeName = ""
zoneDaylilyGarden.InRangeName = ""

zoneCache = Wherigo.Zone(cartBiGAdventure)
zoneCache.Id="592fdb79-638e-403d-8bb7-b26570f33478"
zoneCache.Name="Cache"
zoneCache.Description=[[]]
zoneCache.Visible=false
zoneCache.DistanceRange = Distance(30, "feet")
zoneCache.ShowObjects="OnProximity"
zoneCache.ProximityRange = Distance(15, "feet")
zoneCache.AllowSetPositionTo=false
zoneCache.Active=false
zoneCache.Points = {
  ZonePoint(36.09225,-79.84373,0),
  ZonePoint(36.09225,-79.84365,0),
  ZonePoint(36.09219,-79.84365,0),
  ZonePoint(36.09219,-79.84373,0)
}
zoneCache.OriginalPoint = ZonePoint(36.09222,-79.84369,0)
zoneCache.DistanceRangeUOM = "Feet"
zoneCache.ProximityRangeUOM = "Feet"
zoneCache.OutOfRangeName = ""
zoneCache.InRangeName = ""

-- Characters --
zcharacterArguingCouple = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneArguingCouple}
zcharacterArguingCouple.Id="f98f2bf8-06b0-429c-a81c-2c18f40158fb"
zcharacterArguingCouple.Name="Arguing Couple"
zcharacterArguingCouple.Description=[[]]
zcharacterArguingCouple.Visible=true
zcharacterArguingCouple.Media=zmediaarguingcouple
zcharacterArguingCouple.Gender="Male"
zcharacterArguingCouple.Type="NPC"
zcharacterArguingCouple.ObjectLocation = ZonePoint(36.0924512991291,-79.8423700012053,360)
zcharacterArguingCouple.Commands = {
  Listen = Wherigo.ZCommand{Text="Listen", CmdWith=false, Enabled=true, EmptyTargetListText="You can't hear the couple from that range."},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="They're hard of hearing.  Get closer."},
}
zcharacterArguingCouple.Commands.Listen.Custom = true
zcharacterArguingCouple.Commands.Listen.Id="185f18ae-7dc1-4f87-ad1a-b9be16d6b91b"
zcharacterArguingCouple.Commands.Listen.WorksWithAll = true
zcharacterArguingCouple.Commands.Ask.Custom = true
zcharacterArguingCouple.Commands.Ask.Id="43e1f8d4-bd5d-44cf-ae91-f37444ee92e6"
zcharacterArguingCouple.Commands.Ask.WorksWithAll = true

zcharacterEngrossedReader = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneEngrossedReader}
zcharacterEngrossedReader.Id="db44b48d-0ec6-425a-9045-ead4a6e96dcd"
zcharacterEngrossedReader.Name="Engrossed Reader"
zcharacterEngrossedReader.Description=[[]]
zcharacterEngrossedReader.Visible=true
zcharacterEngrossedReader.Media=zmediaengrossedreader
zcharacterEngrossedReader.Gender="Male"
zcharacterEngrossedReader.Type="NPC"
zcharacterEngrossedReader.ObjectLocation = ZonePoint(36.0941912991288,-79.8432900012055,360)
zcharacterEngrossedReader.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="He's not paying you any mind."},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="He's too far away to ask."},
}
zcharacterEngrossedReader.Commands.Talk.Custom = true
zcharacterEngrossedReader.Commands.Talk.Id="29d83ec7-881e-4f05-b379-af3879934461"
zcharacterEngrossedReader.Commands.Talk.WorksWithAll = true
zcharacterEngrossedReader.Commands.Ask.Custom = true
zcharacterEngrossedReader.Commands.Ask.Id="7a7b4c8d-b5b0-42e5-849e-6aa4dac76345"
zcharacterEngrossedReader.Commands.Ask.WorksWithAll = true

zcharacterSadie = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneGirl}
zcharacterSadie.Id="2510a6cf-e9a4-4778-b42e-8bfa1139ad42"
zcharacterSadie.Name="Sadie"
zcharacterSadie.Description=[[She lost something.]]
zcharacterSadie.Visible=true
zcharacterSadie.Media=zmediasadie
zcharacterSadie.Gender="Female"
zcharacterSadie.Type="NPC"
zcharacterSadie.ObjectLocation = ZonePoint(36.09252,-79.84353,0)
zcharacterSadie.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="She ran off somewhere and didn't hear you."},
  Hi = Wherigo.ZCommand{Text="Hi", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  GiveiPod = Wherigo.ZCommand{Text="Give iPod", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zcharacterSadie.Commands.Talk.Custom = true
zcharacterSadie.Commands.Talk.Id="fa4ce0ab-09a7-45bf-af37-d1436794aba2"
zcharacterSadie.Commands.Talk.WorksWithAll = true
zcharacterSadie.Commands.Hi.Custom = true
zcharacterSadie.Commands.Hi.Id="7ef80954-ff09-4519-a401-060feb9c88f3"
zcharacterSadie.Commands.Hi.WorksWithAll = true
zcharacterSadie.Commands.GiveiPod.Custom = true
zcharacterSadie.Commands.GiveiPod.Id="dc0ee04b-4316-4de8-abc7-5038bee82b70"
zcharacterSadie.Commands.GiveiPod.WorksWithAll = true

zcharacterDogWalker = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneDogWalker}
zcharacterDogWalker.Id="02957228-ebfd-436a-a313-3c46923015d3"
zcharacterDogWalker.Name="Dog Walker"
zcharacterDogWalker.Description=[[]]
zcharacterDogWalker.Visible=true
zcharacterDogWalker.Media=zmediadogwalker
zcharacterDogWalker.Gender="Female"
zcharacterDogWalker.Type="NPC"
zcharacterDogWalker.ObjectLocation = ZonePoint(36.0940712991288,-79.8425400012055,360)
zcharacterDogWalker.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="She's already off running."},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="She's already off running.  Catch up to her."},
}
zcharacterDogWalker.Commands.Talk.Custom = true
zcharacterDogWalker.Commands.Talk.Id="d0dff3ed-d2e3-4893-9252-68e4d21c099c"
zcharacterDogWalker.Commands.Talk.WorksWithAll = true
zcharacterDogWalker.Commands.Ask.Custom = true
zcharacterDogWalker.Commands.Ask.Id="e4012a2f-705f-491d-aacc-b3123bc3179e"
zcharacterDogWalker.Commands.Ask.WorksWithAll = true

zcharacterBen = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneBoyonaBench}
zcharacterBen.Id="7981c981-2974-4126-850e-26deb86d6710"
zcharacterBen.Name="Ben"
zcharacterBen.Description=[[]]
zcharacterBen.Visible=true
zcharacterBen.Media=zmediaboyonbench
zcharacterBen.Gender="Male"
zcharacterBen.Type="NPC"
zcharacterBen.ObjectLocation = ZonePoint(36.0938012991289,-79.8410000012054,360)
zcharacterBen.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zcharacterBen.Commands.Talk.Custom = true
zcharacterBen.Commands.Talk.Id="60c81676-5932-44e8-aa5b-2c7cfbadc13b"
zcharacterBen.Commands.Talk.WorksWithAll = true
zcharacterBen.Commands.Ask.Custom = true
zcharacterBen.Commands.Ask.Id="09235769-200e-42b4-8f1e-6d0dd73a51a1"
zcharacterBen.Commands.Ask.WorksWithAll = true

zcharacterViolinist = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneCamberlysGarden}
zcharacterViolinist.Id="3d0bd95d-7f5e-40a7-9ddc-9d495c9d477e"
zcharacterViolinist.Name="Violinist"
zcharacterViolinist.Description=[[]]
zcharacterViolinist.Visible=true
zcharacterViolinist.Media=zmediaviolinist
zcharacterViolinist.Gender="Female"
zcharacterViolinist.Type="NPC"
zcharacterViolinist.ObjectLocation = ZonePoint(36.0918715118938,-79.8432800014997,360)
zcharacterViolinist.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="She's concentrating too much"},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="She's busy right now."},
}
zcharacterViolinist.Commands.Talk.Custom = true
zcharacterViolinist.Commands.Talk.Id="5e77e55f-291b-4f55-a9aa-5cddfad291b6"
zcharacterViolinist.Commands.Talk.WorksWithAll = true
zcharacterViolinist.Commands.Ask.Custom = true
zcharacterViolinist.Commands.Ask.Id="640b1d5a-38d6-40e1-ad7b-6e2c628120ad"
zcharacterViolinist.Commands.Ask.WorksWithAll = true

zcharacterYoungCouple = Wherigo.ZCharacter{Cartridge=cartBiGAdventure, Container=zoneDaylilyGarden}
zcharacterYoungCouple.Id="832da985-013d-4307-acf2-20f88c7e1125"
zcharacterYoungCouple.Name="Young Couple"
zcharacterYoungCouple.Description=[[]]
zcharacterYoungCouple.Visible=true
zcharacterYoungCouple.Media=zmediayoungcouple
zcharacterYoungCouple.Gender="Female"
zcharacterYoungCouple.Type="NPC"
zcharacterYoungCouple.ObjectLocation = ZonePoint(36.092771299129,-79.8434400012054,360)
zcharacterYoungCouple.Commands = {
  Talk = Wherigo.ZCommand{Text="Talk", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
  Ask = Wherigo.ZCommand{Text="Ask", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zcharacterYoungCouple.Commands.Talk.Custom = true
zcharacterYoungCouple.Commands.Talk.Id="40e55c5a-9337-4b01-a761-5735d2461fd3"
zcharacterYoungCouple.Commands.Talk.WorksWithAll = true
zcharacterYoungCouple.Commands.Ask.Custom = true
zcharacterYoungCouple.Commands.Ask.Id="cf5e3694-009e-4f23-8081-3fb2fb818383"
zcharacterYoungCouple.Commands.Ask.WorksWithAll = true

-- Items --
zitemSadiesiPod = Wherigo.ZItem(cartBiGAdventure)
zitemSadiesiPod.Id="47dda2ff-dd0f-4e42-beba-0173c2670aec"
zitemSadiesiPod.Name="Sadie's iPod"
zitemSadiesiPod.Description=[[A green iPod nano.  It blends in with the grass really well.  She must still have her headphone cables.]]
zitemSadiesiPod.Visible=true
zitemSadiesiPod.ObjectLocation = ZonePoint(36.0922412991291,-79.8419700012053,360)
zitemSadiesiPod.Media=zmediaipod
zitemSadiesiPod.Locked = false
zitemSadiesiPod.Opened = false
zitemSadiesiPod.Commands = {
  PickUp = Wherigo.ZCommand{Text="Pick Up", CmdWith=false, Enabled=true, EmptyTargetListText="Nothing available"},
}
zitemSadiesiPod.Commands.PickUp.Custom = true
zitemSadiesiPod.Commands.PickUp.Id="caad5fe6-c448-4c86-aaaa-8e026296700f"
zitemSadiesiPod.Commands.PickUp.WorksWithAll = true

-- Tasks --
ztaskTheWorriedGirl = Wherigo.ZTask(cartBiGAdventure)
ztaskTheWorriedGirl.Id="8d0489d8-acc9-4765-a3fc-5df67d972ec2"
ztaskTheWorriedGirl.Name="The Worried Girl"
ztaskTheWorriedGirl.Description=[[Some people in the park tell you about a worried girl.  Will you help her?]]
ztaskTheWorriedGirl.Visible=true
ztaskTheWorriedGirl.Active=true
ztaskTheWorriedGirl.Complete=false
ztaskTheWorriedGirl.CorrectState = "None"

ztaskSadiesiPod = Wherigo.ZTask(cartBiGAdventure)
ztaskSadiesiPod.Id="5d77436a-1910-4cee-bf05-d274e4c53a89"
ztaskSadiesiPod.Name="Sadie's iPod"
ztaskSadiesiPod.Description=[[Sadie lost her iPod.  Can you find it?  Some people in the park may have seen it.  It has to be around here somewhere.]]
ztaskSadiesiPod.Visible=true
ztaskSadiesiPod.Active=false
ztaskSadiesiPod.Complete=false
ztaskSadiesiPod.CorrectState = "None"

ztaskFindSadie = Wherigo.ZTask(cartBiGAdventure)
ztaskFindSadie.Id="cf652c51-5ed1-46b8-8fe9-19ad5834b077"
ztaskFindSadie.Name="Find Sadie"
ztaskFindSadie.Description=[[You found her iPod, but where is Sadie?]]
ztaskFindSadie.Visible=true
ztaskFindSadie.Active=false
ztaskFindSadie.Complete=false
ztaskFindSadie.CorrectState = "None"

ztaskMeetSadie = Wherigo.ZTask(cartBiGAdventure)
ztaskMeetSadie.Id="36db914f-78b8-4bfa-b879-c0ad86eb9506"
ztaskMeetSadie.Name="Meet Sadie"
ztaskMeetSadie.Description=[[Meet Sadie at the gazebo.  She wants to show you what she found.]]
ztaskMeetSadie.Visible=true
ztaskMeetSadie.Active=false
ztaskMeetSadie.Complete=false
ztaskMeetSadie.CorrectState = "None"

ztaskFollowSadie = Wherigo.ZTask(cartBiGAdventure)
ztaskFollowSadie.Id="1cef3237-6bae-4cad-8b9e-55d10f56ad4f"
ztaskFollowSadie.Name="Follow Sadie!"
ztaskFollowSadie.Description=[[Sadie found something as well.  What is it?]]
ztaskFollowSadie.Visible=true
ztaskFollowSadie.Active=false
ztaskFollowSadie.Complete=false
ztaskFollowSadie.CorrectState = "None"

ztaskCartridgeComplete = Wherigo.ZTask(cartBiGAdventure)
ztaskCartridgeComplete.Id="069465ae-4253-4962-937c-ee81c36c7677"
ztaskCartridgeComplete.Name="Cartridge Complete"
ztaskCartridgeComplete.Description=[[]]
ztaskCartridgeComplete.Visible=true
ztaskCartridgeComplete.Active=false
ztaskCartridgeComplete.Complete=false
ztaskCartridgeComplete.CorrectState = "None"

-- Cartridge Variables --
-- Builder Variables (to be read by the builder only) --
buildervar = {}
-- ZTimers --

-- Inputs --

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zcharacterEngrossedReader:OnTalk()
-- #GroupDescription=Talk to reader --
-- #Comment=Talk to reader Comment --
Wherigo.Dialog{{Text=[[You begin to say hi, but he quickly puts a hand up.  You wait and he begins to read aloud.]],},{Text=[["We are riding now across the blackness on a road that looks like cheesecloth.  Enemy citadel, conquered nation, trap, ancestral home...  We shall see.  There is a faint flickering from battlement and balcony.  We may even be in time for a funeral.  I straighten my back and I loosen my blade.  We will be there before much longer.

"Goodbye and hello, as always."]],},{Text=[[The man looks up at you, closes the book, smiles, and says, "He writes so well.  There goes another book."

From somewhere, he produces the next volume.  You flee before he can read any more.]],},}
end

function zcharacterBen:OnTalk()
-- #GroupDescription=Talk --
-- #Comment=Talk Comment --
Wherigo.Dialog{{Text=[["Mommie said not to talk to strangers."]],Media=zmediaboyonbench},}
end

function zcharacterViolinist:OnTalk()
-- #GroupDescription=Talk --
-- #Comment=Talk Comment --
Wherigo.Dialog{{Text=[[Sweet sounds fill the air, but all too soon this young woman plays the final chord and lowers her violin.]],Media=zmediaviolinist},{Text=[[You remember that tune and realize she was playing the notes etched into the music stand.

"I learned how to play it in high school and never forgot," she says.]],},{Text=[[As you walk away, the violinist begins to say something.  "There's this girl running around.  I think she's in trouble.  I couldn't help her.  If you see her, ask about it."]],},}
end

function zcharacterYoungCouple:OnTalk()
-- #GroupDescription=Talk --
-- #Comment=Talk Comment --
Wherigo.Dialog{{Text=[[They seem to be talking about what would happen if their baby-to-be lost something.

It appears some girl in the park is in a predicament.]],},}
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --


function zcharacterArguingCouple:OnListen()
-- #GroupDescription=Listen --
-- #Comment=Listen Comment --
Wherigo.Dialog{{Text=[["But it was YOU, dear, who left the cat out last night!" the aging wife reminded her husband.]],Media=zmediaarguingcouple_f},{Text=[[The older gentleman takes a moment to reflect, "But wasn't it Betty that left last.  I coulda sworn I was off to bed."]],Media=zmediaarguingcouple_m},{Text=[["And now poor Mittens was out in that dreadful weather."]],Media=zmediaarguingcouple_f},{Text=[["She's be out before, Dee, and I'm sure Betty let her out."]],Media=zmediaarguingcouple_f},{Text=[[(They don't even notice you as their conversation moves on.)]],},}
end
function zcharacterDogWalker:OnTalk()
-- #GroupDescription=Talk --
-- #Comment=Talk Comment --
--zoneMovers[1]:Pause()
Wherigo.Dialog{{Text=[["If you're going to bring your dog to this park, they are very particular about you cleaning her mess."]],},{Text=[["There's this girl walking around the whole park, looking for something.  If you see what she is looking for, won't you give it to her?]],},}
end











require "math"
























-- =============================================================
--		CARTRIDGE VARIABLES
   ipodLocation = 0		--This tells us where the iPod is
   ipodPickupText = ""		--When the iPod is picked up, this text will display to the player.  It is location-specific, so I will set it beforehand so I do not have to test for it later.
   askText = { }		--This contains all the text displayed when the player asks the characters about the iPod.  Since it is based on location, I have to set it like this.
   zoneMovers = { }
-- =============================================================




function cartBiGAdventure:OnStart()
-- #GroupDescription=OnStart --
-- #Comment=OnStart Comment --
Wherigo.MessageBox{Text=[[Everything in this cartridge can be accomplished on the park's paths or by approaching benches in the grass.  There is no reason for you to disturb the plans in this area or make tracks.  Please respect the environment.]],Media=zmediakeepoffgrass}

--We need to hide the iPod.  We do this randomly and store a location index so the characters can pick up on it and hints can be offered.
ipodLocation = math.random(0,12)	--So far, 13 random locations.


zitemSadiesiPod.Visible = false


--Why lua does not have a switch/case statement is beyond me...
if ipodLocation == 0 then
	--The iPod will be with the arguing couple

	zitemSadiesiPod:MoveTo(zoneArguingCouple)
	ipodPickupText = "It's not trash, it's an iPod."

	--Arguing couple
	askText[1] = "There's something in the grass, but that's too small.  It's probably trash.  Nah."
	--Ben (NE bench)
	askText[2] = "Sadie is my friend.  I've looked all around this corner of the park and didn't see it.  You won't tell mommie I talked to a stranger, right?"
	--Dog walker
	askText[3] = "I haven't seen anything like that.  I'll keep my eyes open, but I don't think I'll see it."
	--Reader (NW bench)
	askText[4] = "I never saw her with such a thing.  Not that I was really paying attention, but I did see that girl walking around a few times.  I wonder if she has any eBooks on it?"
	--Young couple (daylily garden)
	askText[5] = "We thought we saw her playing with it around here, but she had it with her when she crossed the bridge."
	--Violinist
	askText[6] = "Not that I've seen over here.  You might want to try on the other side of the park."

elseif ipodLocation == 1 then
	--The iPod will be with the boy on the bench
	
	zitemSadiesiPod:MoveTo(zoneBoyonaBench)
	ipodPickupText = "Ben hands you the iPod."

	askText[1] = "We haven't seen anything like that doodad."
	askText[2] = "After Sadie and I were done playing, I found it.  Would you please give it to her?  She hasn't come this way in a while."
	askText[3] = "I remember seeing that girl playing with a boy.  If you ask him, I'm sure he might know."
	askText[4] = "I never saw her with such a thing.  Not that I was really paying attention, but I did see that girl walking around a few times.  I wonder if she has any eBooks on it?"
	askText[5] = "We thought we saw her playing with it around here, but she had it with her when she crossed the bridge."
	askText[6] = "Not that I've seen over here.  You might want to try on the other side of the park."

elseif ipodLocation == 2 then
	--In Camberlys Garden

	zitemSadiesiPod:MoveTo(zoneCamberlysGarden)
	ipodPickupText = "The violinist points her bow to the iPod, sitting in the grass near a bench.  She was hoping Sadie would come back for it."

	askText[1] = "That girl had something, we guess, some time around here.  She didn't later, though."
	askText[2] = "Sadie is my friend.  I've looked all around this corner of the park and didn't see it.  You won't tell mommie I talked to a stranger, right?"
	askText[3] = "I haven't seen anything like that.  I'll keep my eyes open, but I don't think I'll see it."
	askText[4] = "I never saw her with such a thing.  Not that I was really paying attention, but I did see that girl walking around a few times.  I wonder if she has any eBooks on it?"
	askText[5] = "She was playing a lot over here and spent a while listening to that person playing the violin.  Perhaps she can help you?"
	askText[6] = "It was on that bench over there, but fell into the grass.  I'm sure you can see it from here.  She said I had a long way to go before I could beat Hannah Montanna.  What was she thinking?"

elseif ipodLocation == 3 then 
	--In the daylily garden

	zitemSadiesiPod:MoveTo(zoneDaylilyGarden)
	ipodPickupText = "You accept the iPod from the young couple.  They hope their unborn child will be able to rely on the kindness of others."

	askText[1] = "That kid was playing across the stream a lot.  I wonder if she lost it there?"
	askText[2] = "Sadie is my friend.  I've looked all around this corner of the park and didn't see it.  You won't tell mommie I talked to a stranger, right?"
	askText[3] = "I haven't seen anything like that.  I'll keep my eyes open, but I don't think I'll see it."
	askText[4] = "I never saw her with such a thing.  Not that I was really paying attention, but I did see that girl walking around a few times.  I wonder if she has any eBooks on it?"
	askText[5] = "We found it in the grass over here.  Are you helping her search?"
	askText[6] = "She had it with her a few times when she was listening to me play, but after a while she didn't have it on her.  I thought she gave it to her mom.  It might still be around here."

elseif ipodLocation == 4 then
	--With the dog walker

	zitemSadiesiPod:MoveTo(zoneDogWalker)
	ipodPickupText = "You receive the iPod from the person walking the dog, but don't escape fast enough to avoid a few licks."

	askText[1] = "That kid?  No, we don't remember."
	askText[2] = "Sadie is my friend.  We were playing a lot over here, but I haven't seen it yet."
	askText[3] = "I saw it on the ground a few minutes ago.  If you're looking for it with her, I'll let you pick it up from me."
	askText[4] = "That girl was around here a lot.  I remember because she was yelling with that kid over there.  I couldn't concentrate on my book."
	askText[5] = "Not that I've seen over here.  You might want to try on the other side of the park."
	askText[6] = "She was listening to me play for a while, but I think she had it with her when she left."

elseif ipodLocation == 5 then
	--At the donation pillar

	zitemSadiesiPod:MoveTo(zoneDonationPillar)
	ipodPickupText = "Someone had propped the iPod up against the pillar in hopes whoever lost it would see.  You pick it up."

	askText[1] = "Oh, we don't know.  She was around here a lot, the poor kid.  Probably fell out of her pocket.  Irresponsible of her."
	askText[2] = "Sadie is my friend.  I've looked all around this corner of the park and didn't see it.  You won't tell mommie I talked to a stranger, right?"
	askText[3] = "I haven't seen anything like that.  I'll keep my eyes open, but I don't think I'll see it."
	askText[4] = "That girl was around here a lot.  I remember because she was yelling with that kid over there.  I couldn't concentrate on my book."
	askText[5] = "Not that I've seen over here.  You might want to try on the other side of the park."
	askText[6] = "She was listening to me play for a while, but I think she had it with her when she left."

elseif ipodLocation == 6 then
	--At the engrossed reader

	zitemSadiesiPod:MoveTo(zoneEngrossedReader)
	ipodPickupText = "You pick up the iPod from the reader, who seems annoyed people are bothering him so much."

	askText[1] = "We haven't seen anything like that doodad."
	askText[2] = "Sadie is my friend.  We were playing a lot over here, but I haven't seen it yet."
	askText[3] = "I haven't seen anything like that.  I'll keep my eyes open, but I don't think I'll see it."
	askText[4] = "Yeah, she dropped it over here.  Some people gave it to me to give to her, but I haven't seen her yet.  Do you want to give it to her?"
	askText[5] = "Not that I've seen over here.  You might want to try on the other side of the park."
	askText[6] = "She was listening to me play for a while, but I think she had it with her when she left."

elseif ipodLocation == 7 then
	--In the picnic area

	zitemSadiesiPod:MoveTo(zonePicnicArea)
	ipodPickupText = "You retrieved the iPod from a bush in the picnic area."

	askText[1] = "What player?  Is that some sort of baseball game?"
	askText[2] = "Sadie is my friend.  I know we were playing around here somewhere after lunch.  I don't know where else to look."
	askText[3] = "I haven't seen something like that, but I did see that girl playing around here."
	askText[4] = "That girl was playing around somewhere, but I wasn't paying attention."
	askText[5] = "I haven't seen anything like that.  Are you sure she didn't already find it?"
	askText[6] = "I haven't seen a girl today.  I don't think was around here."

elseif ipodLocation == 8 then
	--statue - on the fence

	zitemSadiesiPod:MoveTo(zoneStatueOntheFence)
	ipodPickupText = "You picked up the iPod, which had fallen in the grass near the statue."

	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I don't know where else.  We were hanging upside down on something.  Perhaps that's where her iPod is?"
	askText[3] = "That girl and her friend were running every which way.  It wouldn't be surprising it was lost in the grass."
	askText[4] = "No, I haven't seen her.  Maybe you could use that dog to sniff out what you're looking for."
	askText[5] = "Those kids were all over stuff over here and across the stream.  I bet they lost it some time then."
	askText[6] = "Those two kids were being too loud and disturbing my practice.  I asked them to leave."

elseif ipodLocation == 9 then
	--The soar statue

	zitemSadiesiPod:MoveTo(zoneStatueSoar)
	ipodPickupText = "You found the iPod in one of the plants at the base of the statue."

	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I don't know where else.  I know we were across that stream a lot."
	askText[3] = "That girl and her friend were running every which way.  It wouldn't be surprising it was lost in the grass."
	askText[4] = "No, I haven't seen her.  Maybe you could use that dog to sniff out what you're looking for."
	askText[5] = "Those kids were all over stuff over here.  I bet they lost it some time then."
	askText[6] = "Those two kids were being too loud and disturbing my practice.  They just wouldn't leave.  I can't say, though, I'm happy she lost something of hers."

elseif ipodLocation == 10 then
	--student statue

	zitemSadiesiPod:MoveTo(zoneStatueTheStudent)
	ipodPickupText = "You found the iPod in one of the plants at the base of the statue."

	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I don't know where else.  I know we were across that stream a lot."
	askText[3] = "That girl and her friend were running every which way.  It wouldn't be surprising it was lost in the grass."
	askText[4] = "No, I haven't seen her.  Maybe you could use that dog to sniff out what you're looking for."
	askText[5] = "Those kids were all over stuff over here.  I bet they lost it some time then."
	askText[6] = "Those two kids were being too loud and disturbing my practice.  They just wouldn't leave.  I can't say, though, I'm happy she lost something of hers."

--elseif ipodLocation == 11 then
	--wings statue

--	zitemSadiesiPod:MoveTo(zoneStatueWings)
--	ipodPickupText = "You picked up the iPod, which had fallen in the grass near the statue."

--	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
--	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I do not know where else.  I know we had it after we finished playing on the fence.  Where else did we go?"
--	askText[3] = "That girl and her friend were running every which way.  It would not be surprising it was lost in the grass."
--	askText[4] = "No, I have not seen her.  Maybe you could use that dog to sniff out what you're looking for."
--	askText[5] = "Those kids were all over stuff over here and across the stream.  I bet they lost it some time then."
--	askText[6] = "Those two kids were being too loud and disturbing my practice.  I asked them to leave."

elseif ipodLocation == 11 then
	--sundial

	zitemSadiesiPod:MoveTo(zoneSundial)
	ipodPickupText = "You picked up the iPod, which had fallen in the grass near the statue."

	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I don't know where else.  I know we had it after we finished playing on the fence.  Where else did we go?"
	askText[3] = "That girl and her friend were running every which way.  It wouldn't be surprising it was lost in the grass."
	askText[4] = "No, I haven't seen her.  Maybe you could use that dog to sniff out what you're looking for."
	askText[5] = "Those kids were all over stuff over here and across the stream.  I bet they lost it some time then."
	askText[6] = "Those two kids were being too loud and disturbing my practice.  I asked them to leave."

elseif ipodLocation == 12 then
	--gazebo

	zitemSadiesiPod:MoveTo(zoneWeddingGazebo)
	ipodPickupText = "You noticed a tiny corner of the iPod sticking up out of the chips around the gazebo.  You wiped the dirt off and put it in your pocket."

	askText[1] = "Did you see those kids?  They were running up and down, playing on everything.  Their parents should teach them better than to play on statues!  Why, when we were raising our kids, we never let them be that wild."
	askText[2] = "Sadie is my friend.  I know we were playing on stuff, but I don't know where else.  I know we had it after we finished playing on the fence.  Where else did we go?"
	askText[3] = "That girl and her friend were running every which way.  They mostly kept across the eastern parking area."
	askText[4] = "No, I haven't seen her.  I could hear her and this other kid across the park."
	askText[5] = "Those kids were all over stuff over here and across the stream.  I bet they lost it nearby."
	askText[6] = "I kept seeing them somewhere across the stream to the east.  You might want to check over there."

end --end if



zoneMovers = { nil, nil }

--MoveSadie()
--MoveDogWalker()

--Start the ZoneMovers
--zoneMovers[0]:Run()
--zoneMovers[1]:Run()

end



function zoneGirl:OnEnter()

	if not ztaskMeetSadie.Active then
		--zoneMovers[0]:PauseFor(15)
		zcharacterSadie.ObjectLocation = ZonePoint(zoneGirl.Points[1].latitude, zoneGirl.Points[1].longitude)
	end
end
function zoneDogWalker:OnEnter()
	--zoneMovers[1]:PauseFor(15)
	zcharacterDogWalker.ObjectLocation = ZonePoint(zoneDogWalker.Points[1].latitude, zoneDogWalker.Points[1].longitude)
end
function zoneGirl:OnProximity()
	if not ztaskMeetSadie.Active then
		--zoneMovers[0]:PauseFor(15)
		zcharacterSadie.ObjectLocation = ZonePoint(zoneGirl.Points[1].latitude, zoneGirl.Points[1].longitude)
	end
end
function zoneDogWalker:OnProximity()
	--zoneMovers[1]:PauseFor(15)
	zcharacterDogWalker.ObjectLocation = ZonePoint(zoneDogWalker.Points[1].latitude, zoneDogWalker.Points[1].longitude)
end
--function zoneGirl:OnExit()
--	zoneMovers[0]:Resume()
--	Wherigo.MessageBox{Text=[[Exit.]],}
--end
--function zoneDogWalker:OnExit()
--	zoneMovers[1]:Resume()
--end
--function zoneGirl:OnDistant()
--	zoneMovers[0]:Resume()
--end
--function zoneDogWalker:OnDistant()
--	zoneMovers[1]:Resume()
--end


function zcharacterSadie:OnTalk()
-- #GroupDescription=Talk to Sadie --
-- #Comment=Talk to Sadie Comment --

--zoneMovers[0]:Pause()
if not ztaskTheWorriedGirl.Complete then
	Wherigo.Dialog{{Text=[[The young girl is looking very distraught.  You stop her and ask what's the matter.]],},{Text=[[She looks up at you, very worried.  "I lost my iPod somewhere and I'm trying to find it.  Won't you please help?  It's green and should be around here somewhere.  If you see it, can you give it to me?  My name is Sadie."]],Media=zmediasadie},{Text=[[You nod your head, she smiles, and hurries away.

NEW TASK: Find Sadie's iPod.]],},}
	ztaskTheWorriedGirl.Complete = true
	ztaskSadiesiPod.Visible = true
	ztaskSadiesiPod.Active = true

	EnableCommand("Ask", true)

	zcharacterSadie.Description=[[She is looking for her iPod.  Where could it be?]]
	zoneGirl.Description = [[]]

	zoneGirl.Name = "Sadie"

	zitemSadiesiPod.Visible = true

else
	Wherigo.MessageBox{Text=[[Have you found it yet?  I haven't.  It has to be around here somewhere.  I didn't go off that sidewalk that much.  Maybe someone picked it up?]],}

end
--zoneMovers[0]:PauseFor(10)
end



function zcharacterArguingCouple:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
Wherigo.Dialog{{Text=askText[1]},}
end
function zcharacterBen:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
Wherigo.Dialog{{Text=askText[2],},}
end
function zcharacterDogWalker:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
--zoneMovers[1]:Pause()
Wherigo.Dialog{{Text=askText[3],},}
end
function zcharacterEngrossedReader:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
Wherigo.Dialog{{Text=askText[4],},}
end
function zcharacterYoungCouple:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
Wherigo.Dialog{{Text=askText[5],},}
end
function zcharacterViolinist:OnAsk()
-- #GroupDescription=Ask --
-- #Comment=Ask Comment --
Wherigo.Dialog{{Text=askText[6],},}
end



function zitemSadiesiPod:OnPickUp()
-- #GroupDescription=Pick Up --
-- #Comment=Pick Up Comment --
zitemSadiesiPod:MoveTo(Player)
Wherigo.MessageBox{Text=ipodPickupText .. [[  You found Sadie's iPod!  But where is Sadie?

NEW TASK: Find Sadie]],}
ztaskSadiesiPod.Complete = true
ztaskFindSadie.Visible = true
ztaskFindSadie.Active = true

EnableCommand("Ask", false)
zcharacterSadie.Commands["Talk"].Enabled = false
zcharacterSadie.Commands["GiveiPod"].Enabled = true
zitemSadiesiPod.Commands["PickUp"].Enabled = false

zcharacterSadie.Description=[[A young girl, eager to get that iPod back...]]
end





function zcharacterSadie:OnGiveiPod()
-- #GroupDescription=Give iPod --
-- #Comment=Give iPod Comment --
--zoneMovers[0]:Pause()

Wherigo.Dialog{{Text=[[With a smile, you take the iPod out from your pocket and give it to Sadie.  A big grin plays across her face.  She almost jumps for joy.]],},{Text=[["Thank you, thank you," she gushes.  It takes a moment for her to regain her composure.

"I'm gonna give this to mom and I'll be right back.  I wanna show you something I found, too.  Let's meet at that place I saw a wedding."

She runs off to her mother.

NEW TASK: Meet Sadie]],},}
ztaskFindSadie.Complete = true
ztaskMeetSadie.Visible = true
ztaskMeetSadie.Active = true
zcharacterSadie.Commands["GiveiPod"].Enabled = false
zcharacterSadie.Commands["Talk"].Enabled = false
zcharacterSadie.Commands["Hi"].Enabled = true
zcharacterSadie.Description=[[A young girl, now very happy to have her iPod returned to her.  She found something she wants to show you.]]
zitemSadiesiPod.Visible = false


--I need to move the zone to the gazebo
--zoneGirl.Active = false

--		for x=1,table.getn(zoneGirl.Points) do
--			zoneGirl.Points[x].latitude = zoneWeddingGazebo.Points[x].latitude
--			zoneGirl.Points[x].longitude = zoneWeddingGazebo.Points[x].longitude
--		end

--zoneGirl.Active = true

--I need to refresh the character location
--zcharacterSadie.Active = false
--zcharacterSadie:MoveTo(zoneGirl)
--zcharacterSadie.ObjectLocation = ZonePoint(zoneGirl.Points[1].latitude, zoneGirl.Points[1].longitude)
--zcharacterSadie.Active = true

zcharacterSadie.ObjectLocation = ZonePoint(zoneSadie.Points[1].latitude, zoneSadie.Points[1].longitude)
zoneGirl.Active = false
zoneSadie.Active = true
zcharacterSadie:MoveTo(zoneSadie)
end




function zcharacterSadie:OnHi()
-- #GroupDescription=Hi --
-- #Comment=Hi Comment --

MoveSadieGazebo()

Wherigo.Dialog{{Text=[["Hi again.  Follow me and I'll show you what I found.  It's across the bridge, on a trail, behind a bench."

NEW TASK: Follow Sadie!]],},Callback=zoneMovers[2]:Run()}
ztaskMeetSadie.Complete = true
ztaskFollowSadie.Visible = true
ztaskFollowSadie.Active = true
zoneCache.Active = true
zoneCache.Visible = true

--zoneMovers[1]:Pause()

zoneArguingCouple.Active = false
zoneCamberlysGarden.Active = false
zoneDaylilyGarden.Active = false
zoneEngrossedReader.Active = false
zoneBoyonaBench.Active = false
zoneDogWalker.Active = false
zoneDonationPillar.Active = false
zonePicnicArea.Active = false
zoneStatueOntheFence.Active = false
zoneStatueSoar.Active = false
--zoneStatueWings.Active = false
zoneStatueTheStudent.Active = false
zoneSundial.Active = false
zoneWeddingGazebo.Active = false

zcharacterSadie.Commands["Hi"].Enabled = false
end



function zoneCache:OnProximity()
-- #GroupDescription=Enter Cache --
-- #Comment=Enter Cache Comment --
zoneMovers[2]:Pause()
--zoneMovers[1]:Pause()
zoneCache.Active = false
zoneGirl.Active = false
zoneSadie.Active = false
zoneDogWalker.Active = false
Wherigo.Dialog{{Text=[[Sadie waves you closer, near to a park bench.  She points to the base of a tree.

"Look what I found in there.  See it?  From the back of the bench, it's that bush to the left of the tree.  Right at the base of the bush, next to the rocks.  What is that?"]],},{Text=[[It's a geocache!

Congratulations on completing the cartridge and helping Sadie!]],},{Text=[[This cartridge was created by Ranger Fox.
Thank you to:
Bicentennial Gardens
egodeflator
and geocachers like you


Created February 2009
Copyright 2009, Ranger Fox Adventures, Ltd.]],},}
ztaskFollowSadie.Complete = true
ztaskCartridgeComplete.Visible = true
ztaskCartridgeComplete.Complete = true
cartBiGAdventure.Complete = true
end




function EnableCommand(commandName, enabled)
	zcharacterArguingCouple.Commands[commandName].Enabled = enabled
	zcharacterBen.Commands[commandName].Enabled = enabled
	zcharacterDogWalker.Commands[commandName].Enabled = enabled
	zcharacterEngrossedReader.Commands[commandName].Enabled = enabled
	zcharacterViolinist.Commands[commandName].Enabled = enabled
	zcharacterYoungCouple.Commands[commandName].Enabled = enabled
end 








function MoveSadie()
pointsToMove = { CreateZMPoint(ZonePoint(36.09243,-79.84356), 1, 0),
CreateZMPoint(ZonePoint(36.09242,-79.84355), 9, 0),
CreateZMPoint(ZonePoint(36.09236,-79.84347), 13, 0),
CreateZMPoint(ZonePoint(36.09226,-79.84336), 7, 0),
CreateZMPoint(ZonePoint(36.09224,-79.84336), 5, 0),
CreateZMPoint(ZonePoint(36.09222,-79.84331), 11, 0),
CreateZMPoint(ZonePoint(36.09210,-79.84320), 3, 0),
CreateZMPoint(ZonePoint(36.09209,-79.84316), 4, 0),
CreateZMPoint(ZonePoint(36.09205,-79.84314), 11, 0),
CreateZMPoint(ZonePoint(36.09200,-79.84325), 9, 0),
CreateZMPoint(ZonePoint(36.09201,-79.84335), 4, 0),
CreateZMPoint(ZonePoint(36.09204,-79.84342), 10, 0),
CreateZMPoint(ZonePoint(36.09208,-79.84358), 5, 0),
CreateZMPoint(ZonePoint(36.09213,-79.84359), 10, 0),
CreateZMPoint(ZonePoint(36.09223,-79.84350), 8, 0),
CreateZMPoint(ZonePoint(36.09231,-79.84349), 3, 0),
CreateZMPoint(ZonePoint(36.09237,-79.84350), 11, 0),
CreateZMPoint(ZonePoint(36.09249,-79.84351), 9, 0),
CreateZMPoint(ZonePoint(36.09257,-79.84340), 7, 0),
CreateZMPoint(ZonePoint(36.09258,-79.84328), 4, 0),
CreateZMPoint(ZonePoint(36.09255,-79.84323), 2, 0),
CreateZMPoint(ZonePoint(36.09253,-79.84322), 12, 0),
CreateZMPoint(ZonePoint(36.09238,-79.84311), 7, 0),
CreateZMPoint(ZonePoint(36.09233,-79.84299), 6, 0),
CreateZMPoint(ZonePoint(36.09228,-79.84289), 2, 0),
CreateZMPoint(ZonePoint(36.09226,-79.84286), 6, 0),
CreateZMPoint(ZonePoint(36.09225,-79.84274), 11, 0),
CreateZMPoint(ZonePoint(36.09230,-79.84268), 8, 0),
CreateZMPoint(ZonePoint(36.09235,-79.84279), 14, 0),
CreateZMPoint(ZonePoint(36.09250,-79.84298), 1, 0),
CreateZMPoint(ZonePoint(36.09250,-79.84298), 8, 0),
CreateZMPoint(ZonePoint(36.09260,-79.84291), 11, 0),
CreateZMPoint(ZonePoint(36.09254,-79.84276), 14, 0),
CreateZMPoint(ZonePoint(36.09243,-79.84258), 13, 0),
CreateZMPoint(ZonePoint(36.09232,-79.84237), 14, 0),
CreateZMPoint(ZonePoint(36.09226,-79.84209), 2, 0),
CreateZMPoint(ZonePoint(36.09226,-79.84205), 8, 0),
CreateZMPoint(ZonePoint(36.09222,-79.84191), 12, 0),
CreateZMPoint(ZonePoint(36.09227,-79.84174), 13, 0),
CreateZMPoint(ZonePoint(36.09236,-79.84150), 10, 0),
CreateZMPoint(ZonePoint(36.09246,-79.84142), 14, 0),
CreateZMPoint(ZonePoint(36.09235,-79.84130), 14, 0),
CreateZMPoint(ZonePoint(36.09228,-79.84115), 9, 0),
CreateZMPoint(ZonePoint(36.09229,-79.84116), 10, 0),
CreateZMPoint(ZonePoint(36.09237,-79.84129), 4, 0),
CreateZMPoint(ZonePoint(36.09241,-79.84134), 11, 0),
CreateZMPoint(ZonePoint(36.09253,-79.84140), 4, 0),
CreateZMPoint(ZonePoint(36.09258,-79.84138), 16, 0),
CreateZMPoint(ZonePoint(36.09274,-79.84121), 2, 0),
CreateZMPoint(ZonePoint(36.09276,-79.84118), 11, 0),
CreateZMPoint(ZonePoint(36.09287,-79.84102), 11, 0),
CreateZMPoint(ZonePoint(36.09307,-79.84099), 1, 0),
CreateZMPoint(ZonePoint(36.09308,-79.84099), 10, 0),
CreateZMPoint(ZonePoint(36.09318,-79.84111), 16, 0),
CreateZMPoint(ZonePoint(36.09336,-79.84127), 14, 0),
CreateZMPoint(ZonePoint(36.09351,-79.84139), 14, 0),
CreateZMPoint(ZonePoint(36.09359,-79.84162), 1, 0),
CreateZMPoint(ZonePoint(36.09360,-79.84165), 5, 0),
CreateZMPoint(ZonePoint(36.09360,-79.84175), 2, 0),
CreateZMPoint(ZonePoint(36.09360,-79.84179), 6, 0),
CreateZMPoint(ZonePoint(36.09367,-79.84184), 15, 0),
CreateZMPoint(ZonePoint(36.09389,-79.84192), 11, 0),
CreateZMPoint(ZonePoint(36.09402,-79.84202), 5, 0),
CreateZMPoint(ZonePoint(36.09405,-79.84208), 12, 0),
CreateZMPoint(ZonePoint(36.09405,-79.84224), 3, 0),
CreateZMPoint(ZonePoint(36.09406,-79.84230), 2, 0),
CreateZMPoint(ZonePoint(36.09405,-79.84233), 5, 0),
CreateZMPoint(ZonePoint(36.09405,-79.84241), 3, 0),
CreateZMPoint(ZonePoint(36.09404,-79.84245), 12, 0),
CreateZMPoint(ZonePoint(36.09406,-79.84263), 8, 0),
CreateZMPoint(ZonePoint(36.09410,-79.84276), 13, 0),
CreateZMPoint(ZonePoint(36.09413,-79.84294), 7, 0),
CreateZMPoint(ZonePoint(36.09410,-79.84307), 4, 0),
CreateZMPoint(ZonePoint(36.09407,-79.84314), 10, 0),
CreateZMPoint(ZonePoint(36.09397,-79.84331), 7, 0),
CreateZMPoint(ZonePoint(36.09388,-79.84337), 12, 0),
CreateZMPoint(ZonePoint(36.09367,-79.84348), 10, 0),
CreateZMPoint(ZonePoint(36.09353,-79.84351), 14, 0),
CreateZMPoint(ZonePoint(36.09336,-79.84346), 6, 0),
CreateZMPoint(ZonePoint(36.09329,-79.84343), 11, 0),
CreateZMPoint(ZonePoint(36.09316,-79.84333), 10, 0),
CreateZMPoint(ZonePoint(36.09305,-79.84313), 8, 0),
CreateZMPoint(ZonePoint(36.09297,-79.84302), 12, 0),
CreateZMPoint(ZonePoint(36.09281,-79.84308), 5, 0),
CreateZMPoint(ZonePoint(36.09276,-79.84305), 7, 0),
CreateZMPoint(ZonePoint(36.09268,-79.84296), 4, 0),
CreateZMPoint(ZonePoint(36.09263,-79.84298), 4, 0),
CreateZMPoint(ZonePoint(36.09258,-79.84301), 4, 0),
CreateZMPoint(ZonePoint(36.09254,-79.84303), 10, 0),
CreateZMPoint(ZonePoint(36.09258,-79.84319), 6, 0),
CreateZMPoint(ZonePoint(36.09259,-79.84329), 4, 0),
CreateZMPoint(ZonePoint(36.09264,-79.84334), 7, 0),
CreateZMPoint(ZonePoint(36.09274,-79.84342), 4, 0),
CreateZMPoint(ZonePoint(36.09273,-79.84349), 15, 0),
CreateZMPoint(ZonePoint(36.09252,-79.84353), 9, 0),
CreateZMPoint(ZonePoint(36.09242,-79.84354), 6, 0)
}

--zoneMovers[0] = CreateZoneMover(zoneGirl, pointsToMove)

--zoneMovers[0].repeatOnComplete = true

end



function MoveDogWalker()

pointsToMove = {CreateZMPoint(ZonePoint(36.09362,-79.84193), 1, 0),
CreateZMPoint(ZonePoint(36.09363,-79.84193), 13, 0),
CreateZMPoint(ZonePoint(36.09383,-79.84192), 13, 0),
CreateZMPoint(ZonePoint(36.09404,-79.84200), 12, 0),
CreateZMPoint(ZonePoint(36.09413,-79.84209), 19, 0),
CreateZMPoint(ZonePoint(36.09412,-79.84236), 10, 0),
CreateZMPoint(ZonePoint(36.09410,-79.84248), 21, 0),
CreateZMPoint(ZonePoint(36.09383,-79.84253), 22, 0),
CreateZMPoint(ZonePoint(36.09362,-79.84267), 21, 0),
CreateZMPoint(ZonePoint(36.09340,-79.84255), 8, 0),
CreateZMPoint(ZonePoint(36.09340,-79.84246), 23, 0),
CreateZMPoint(ZonePoint(36.09351,-79.84218), 20, 0),
CreateZMPoint(ZonePoint(36.09359,-79.84193), 7, 0)
}

--zoneMovers[1] = CreateZoneMover(zoneDogWalker, pointsToMove)

--zoneMovers[1].repeatOnComplete = true

end








function MoveSadieGazebo()

--zoneMovers[0]:Pause()

--zoneMovers[0] = nil

gpointsToMove = {CreateZMPoint(ZonePoint(36.09242,-79.84177), 7, 0),
CreateZMPoint(ZonePoint(36.09247,-79.84187), 3, 0),
CreateZMPoint(ZonePoint(36.09247,-79.84191), 6, 0),
CreateZMPoint(ZonePoint(36.09241,-79.84195), 2, 0),
CreateZMPoint(ZonePoint(36.09238,-79.84196), 5, 0),
CreateZMPoint(ZonePoint(36.09232,-79.84200), 7, 0),
CreateZMPoint(ZonePoint(36.09229,-79.84211), 20, 0),
CreateZMPoint(ZonePoint(36.09237,-79.84249), 8, 0),
CreateZMPoint(ZonePoint(36.09241,-79.84265), 14, 0),
CreateZMPoint(ZonePoint(36.09250,-79.84289), 10, 0),
CreateZMPoint(ZonePoint(36.09256,-79.84302), 4, 0),
CreateZMPoint(ZonePoint(36.09255,-79.84302), 3, 0),
CreateZMPoint(ZonePoint(36.09255,-79.84304), 10, 0),
CreateZMPoint(ZonePoint(36.09256,-79.84320), 2, 0),
CreateZMPoint(ZonePoint(36.09256,-79.84323), 19, 0),
CreateZMPoint(ZonePoint(36.09249,-79.84355), 7, 0),
CreateZMPoint(ZonePoint(36.09245,-79.84357), 16, 0),
CreateZMPoint(ZonePoint(36.09225,-79.84353), 2, 0),
CreateZMPoint(ZonePoint(36.09222,-79.84351), 2, 0),
CreateZMPoint(ZonePoint(36.09220,-79.84352), 12, 0),
CreateZMPoint(ZonePoint(36.09223,-79.84370), 1, 0)
}

zoneMovers[2] = CreateZoneMover(zoneSadie, gpointsToMove)

zoneMovers[2].repeatOnComplete = false
zoneMovers[2].startPoint = zoneGirl.Points[1]

zoneMovers[2].OnComplete = function()
	zoneCache.Active = true
	zoneCache.Visible = true
end

end










































function CreateZoneMover(zoneToMove, pointsToMove)
	--All class variables must be declared here
	zm = ZoneMover:new{ zone = zoneToMove }
	zm.zone = zoneToMove
	zm.name = zoneToMove.Name
	--zm.zoneRadius = zoneradius

	zm.ZMPoints = pointsToMove


	zm.startPoint = zoneToMove.OriginalPoint
	zm.pointIndex = 0

	zm.OnComplete = function()	
	end 


	return zm
end

function CreateZMPoint(zPoint, duration, pauseAfter)
	--All class variables must be declared here
	zmp = ZMPoint:new{ FinalPoint = zPoint }
	zmp.elapsed = 0
	zmp.FinalPoint = zPoint
	zmp.duration = duration
	zmp.pauseAfter = pauseAfter

	zmp.OnComplete = function()
	end

	return zmp
end



    ZMPoint = {nil}
    function ZMPoint:new (y)
	y = y or {}
	setmetatable(y, self)
        self.__index = self
	elapsed = 0		--for timers to set, this is the time elapsed and progress made to the zone move
	duration = 0		--in this number of seconds, the zone should have been moved to the coordinates
	pauseAfter = 1		--after this zone move is finished, for how many seconds should the ZoneMover pause?
	FinalPoint = nil
	return y
    end

    --Takes in the current zone point and returns where it should be at a specific increment (in seconds)
    function ZMPoint:GetNewPoint(CurrentPoint, secondIncrement)
	self.elapsed = secondIncrement

	--Wherigo.MessageBox{Text=[[Point = ]] .. self.elapsed,}

	return ZonePoint((((self.FinalPoint.latitude - CurrentPoint.latitude) / self.duration) * self.elapsed) + CurrentPoint.latitude, (((self.FinalPoint.longitude - CurrentPoint.longitude) / self.duration) * self.elapsed) + CurrentPoint.longitude)
    end
    	




    ZoneMover = {nil}
    
    function ZoneMover:new (z)
      z = z or {}
      setmetatable(z, self)
      self.__index = self
      name = "undefined"
      --zoneRadius = 30
      timer = nil
      ZMPoints = {nil}


      pointIndex = 0

      return z
    end
    
    function ZoneMover:Zone ()
      return self.zone
    end

    --126
    function ZoneMover:Name ()
	return ZoneMover.name
    end

    function ZoneMover:SetName(n)
        ZoneMover.name = n
	--.. ZoneMover.name
	--Wherigo.MessageBox{Text=[[Passed ]] .. n .. [[ recorded ]] ,}
    end



    function ZoneMover:Pause()
	self.timer:Stop()
    end

    function ZoneMover:PauseFor(seconds)
	self.timer:Stop()
	self.timer.Duration = seconds
	self.timer:Start()
    end

    function ZoneMover:Resume()
	self.timer:Start()
    end

    function ZoneMover:Run()
	self.pointIndex = 1
	self.timer = Wherigo.ZTimer {
		Cartridge = self.zone.Cartridge,
		Name = "Timer",
		Description = "Timer for " .. self.zone.Name,
		Visible = true,
		Duration = 1,
		Type = "Countdown",
		}

	local this = self




	--Create an array of distances and bearings so I know the beginning shape the zone had.  When passed a zonePoint, that point needs to replace the CenterPoint the zone had.  From there, I can apply
	--	the distance and bearings to get the same shape the zone had.
	distance = {}
	bearing = {}
	for x=1,table.getn(self.zone.Points) do
		local d2,b2 = Wherigo.VectorToPoint(self.zone.OriginalPoint, self.zone.Points[x])

		--Right way
		distance[x] = d2
		bearing[x] = b2
	end





	--Wherigo.MessageBox{Text=[[Timer start for ]] .. self.name,}
	self.timer.OnTick = function ()

		--The real code
		this.timer.Duration = 1		--The timer needs its duration set because it may have been equal to a ZMPoint pauseAfter value	

		if this.pointIndex == 0 then	--Base 1 index and not base 0
			this.pointIndex = 1
		end

		--So, where in the ZMPoints array are we?
		local currentZMPoint = this.ZMPoints[this.pointIndex]




		local originalPoint
		if this.pointIndex == 1 then
			originalPoint = this.startPoint
		else
			originalPoint = this.ZMPoints[this.pointIndex - 1].FinalPoint
		end


		





		--I ***NEED*** that colon on this next line.
		local zp = currentZMPoint:GetNewPoint(originalPoint, currentZMPoint.elapsed + 1)


		this.zone.Visible = false
		this.zone.Active = false


		local x
		local txt = ""
		for x=1,table.getn(this.zone.Points) do
			--local newPoint = Wherigo.TranslatePoint(zp, Wherigo.Distance(this.zoneRadius, "ft"), 45 + (360 / table.getn(this.zone.Points) ) * x)
			local newPoint = Wherigo.TranslatePoint(zp, Wherigo.Distance(distance[x], "ft"), bearing[x])

			this.zone.Points[x].latitude = newPoint.latitude
			this.zone.Points[x].longitude = newPoint.longitude

		end

		this.zone.Active = true
		this.zone.Visible = true


		--At the end
		if currentZMPoint.elapsed ~= currentZMPoint.duration then
			this.timer:Start()
		else

			--We are finished moving to this ZMPoint.  Run the callback.
			if this.ZMPoints[this.pointIndex].OnComplete ~= nil then
				this.ZMPoints[this.pointIndex]:OnComplete()
			end

			--Go to the next ZMPoint
			this.pointIndex = this.pointIndex + 1
			if table.getn(this.ZMPoints) >= this.pointIndex then
				if this.ZMPoints[this.pointIndex].pauseAfter > 0 then
					this.timer.Duration = this.ZMPoints[this.pointIndex].pauseAfter
					this.timer:Start()
				else
					this.timer.Duration = 1
					this.timer:Start()
				end
			else
				this:OnComplete()
			--if not, this is the end.
			end
		end

	end

	self.timer:Start()
    end --of ZoneMover:Run
-- #End Author Functions# --
-- Nothing after this line --
return cartBiGAdventure
